unit dialunit;

interface
uses wintypes;

procedure StartSession(CmdLine:pchar;ParWindow:hwnd);
(*
Used by an application to initiate a standard script-based EZDialup session.
The CMDLINE parameter is identical to the command-line parameter described
in the manule and contians the complete path of an .INI file and a .EZD file.
Optionally can begin with the complete path of the executable itself to
ensure the executable is found.
*)

Procedure AbortSession;
(*
Used by an application to have EZDialup immediately hangup and shutdown. 
*)

Procedure ChangePhoneNumber;
(*
Used by an application to have EZDialup immediately hangup, shutdown, and
prompt user for a new dialing sequence.  When user supplies new sequence the
call is begun again. 
*)

Procedure StopEZDialup(ParWindow:hwnd);
(*
Used by an application to have EZDialup remove itself from memory
immediately.  Obsolete, but present for backward compatibility.
*)

(*
The following procedures and functions are used only by applications using
EZDialup to link and remain connected.  The next 11 (SetParentWindow through
SetExecutablePath) procedures must be called before any other commands.
*)

procedure SetParentWindow(ParWindow:hwnd);
(*
Lets EZDialup know where to send status messages.  Execute this procedure
as soon as you app begins - doing so means that if your app terminates
during a connection it can restart and automatically re-attach to EZDialup.
*)

procedure SetDialingSequence(DialStr:pchar);
(*
Sets the dialing sequence EZDialup will use to dial the server.  This
must include any required prefix digits and/or pauses.                 
*)

procedure SetDialupCommPort(PortStr:pchar); 
(*
Set the COMM port to use.  This should look like 'COM1', 'COM2', etc.
*)

procedure SetDialupCommConfig(CfgStr:pchar); 
(*
Sets the actual string passed to Windows to initialize the
communications port - "19200,n,8,1" is a typical example.  
*)

procedure SetModemInit1(InitStr:pchar); 
(*
Sets the first initialization string sent to the modem, usually "ATZ" or
"AT&F"
*)

procedure SetModemInit2(InitStr:pchar); 
(*
Sets the second initialization string sent to the modem.  A typical example
is "AT E0 V1 S0=0 X4"...

AT simply starts the command.

E0 asks the modem not to repeat every command back to the computer.

V1 asks modem to report situations with phrases (e.g. "CONNECT 14400").

X4 asks modem to report statuses with all available detail.

These are the minimal settings.  Additional data-compression codes may be
added if desired.
*)


Procedure SetDownloadBlockSize(Size:integer);      
(*
Used to set the size of data blocks during downloads.  Maximum value
is 4096. 
*)

Procedure SetUploadBlockSize(Size:integer);
(*
Used to set the size of data blocks during upoads.  Maximium value
is 4096. 
*)

procedure SetLinkUserPath(path:pchar);
(*
Used to set the path on the server that contains the password file (COMMPASS)
for the given user.
*)

procedure SetLinkUserPassword(password:pchar);
(*
Used to set the password EZDialup will use to log in to the server.
*)

procedure SetExecutablePath(path:pchar); 
(*
Used to set the complete path of the executable usually named EZDIALUP.EXE,
though you may give the file any other name with an .EXE extension and
specify the new name with this function
*)

procedure EstablishDialupLink;
(*
Used by an application to dial a server immediately.  Not needed, because
all the following commands will establish the link automatically if one does
not already exist.
*)

(*
The following functions have a few things in common:

1) Will establish link automatically if one does not already exist.
2) Returns the command's serial number.  Your app should store this.
3) Your application will receive a message at WMUSER+151 when the command
is finished.  The 16-bit wparam portion of the message will contain the
serial number of command completed, and the 32-bit lparam portion of
the message is a pointer to a null-terminated string that describes
the completion status.  If the string reads "No Errors" then, of course, no
problem occurred during command execution.  Otherwise, the string describes
the problem.
*)

function StartDownload(ServerSource,ClientTarget:pchar):word;
(*
Used to have EZDialup start transferring a file from the server to the
client.  Returns the command's serial number.
*)

function StartUpload(ClientSource,ServerTarget:pchar):word;
(*
Used to have EZDialup start transferring a file from the client to the
server.  Returns the command's serial number.
*)

function StartMoveDown(ServerSource,ClientTarget:pchar):word;
(*
Used to have EZDialup start transferring a file from the server to the
client.  This move is stopped if client finds a file already exists with
the name in the ClientTarget parameter, or if the server can not find a
file with the name in the ServerSource parameter.  If the transfer to the
client is successful, the file on the server is removed.  Returns the
command's serial number.
*)

function StartMoveUp(ClientSource,ServerTarget:pchar):word;
(*
Used to have EZDialup start transferring a file from the client to the
server.  This move is stopped if server finds a file already exists with
the name in the ServerTarget parameter, or if the client can not find a
file with the name in the ClientSource parameter.  If the transfer to the
server is successful, the file on the client is removed.  Returns the
command's serial number.
*)

function UnzipServerFile(ZipFilePath,TargetServerDirectory:pchar):word;
(*
Used to Un-zip the files stored in the server file listed in the ZipFilePath
parameter into the directory specified in the TargetServerDirectory
parameter.  Files are overwritten if already there.  Returns the command's
serial number.  If the Target directory does not exist it will be created
before the unzip.  All zip functions are 2.04g-compatible.
*)

function UnzipClientFile(ZipFilePath,TargetClientDirectory:pchar):word;
(*
Used to Un-zip the files stored in the client file listed in the ZipFilePath
parameter into the directory specified in the TargetClientDirectory
parameter.  Files are overwritten if already there.  Returns the command's
serial number.  If the Target directory does not exist it will be created
before the unzip.  All zip functions are 2.04g-compatible.
*)

function ZipServerFile(TargetZipFile,SourcePathAndFileMask:pchar):word;
(*
Used to add to a server .ZIP file (listed in the TargetZipFile parameter)
the files that match the path/wildcard in SourcePathAndFileMask parameter.
The file is not overwritten if already there - use the DeleteFilesOnServer
command to start a new one.  If the file is already in the .ZIP file, and
the date/time stamp is the same, the file is not added again; but if the
file is newer it will replace the older version.  Returns the command's
serial number.  All zip functions are 2.04g-compatible.
*)

function ZipClientFile(TargetZipFile,SourcePathAndFileMask:pchar):word;
(*
Used to add to a client .ZIP file (listed in the TargetZipFile parameter)
the files that match the path/wildcard in SourcePathAndFileMask parameter.
The file is not overwritten if already there - use the DeleteFilesOnClient
command to start a new one.  If the file is already in the .ZIP file, and
the date/time stamp is the same, the file is not added again; but if the
file is newer it will replace the older version.  Returns the command's
serial number.  All zip functions are 2.04g-compatible.
*)

function DeleteFilesOnServer(SourcePathAndFileMask:pchar):word;
(* 
Used to delete the files on the server that match the path/wildcard, and
can erase a single file or, using the asterisk wild-card symbol, a group
of files.  Returns the command's serial number.
*)

function DeleteFilesOnClient(SourcePathAndFileMask:pchar):word;
(*
Used to delete the files on the client that match the path/wildcard, and
can erase a single file or, using the asterisk wild-card symbol, a group
of files.  Returns the command's serial number.
*)

function RunProgramOnServer(ProgramPath:pchar):word;
(*
Used to run a program on the server.  No furthur commands will be
executed until this program terminates- use LaunchProgramOnServer
to allow command-processing to continue.  

Command line parameters can be included.

Returns the command's serial number.
*)

function RunProgramOnClient(ProgramPath:pchar):word;
(*
Used to run a program on the client.  No furthur commands will be
executed this program terminates - use LaunchProgramOnClient to allow
command-processing to continue.

Command line parameters can be included.

Returns the command's serial number.
*)

function LaunchProgramOnServer(ProgramPath:pchar):word;
(*
Used to run a program on the server.  The program is then ignored, and
additional commands can be executed immediately - use RunProgramOnServer
to require that program terminates before additonal commands can be
processed.

Command line parameters can be included.

Returns the command's serial number.
*)

function LaunchProgramOnClient(ProgramPath:pchar):word;
(*
Used to run a program on the client.  The program is then ignored, and
additional commands can be executed immediately - use RunProgramOnClient
to require that program terminates before additonal commands can be
processed.

Command line parameters can be included.

Returns the command's serial number.
*)

function UpdateClientDirectory(ClientDirectory,
                                ServerDirectory,
                                ClientDateFilePath:pchar):word;
(*
This is a specialized function used to "freshen" (bring up-to-date) an
entire directory structure on a remote PC.  It looks in the server-side
directory (ServerDir) for files newer than the client-side file
(ClientCompareFile).  Sub-directories are included in this search.


All newer files are zipped, then downloaded to the client.  The zip file
is unzipped into the client-side directory (ClientDir), keeping the
directory structure intact.

To use this function, copy an entire directory structure from the
server side to a client.  As files on the server side change and new
files are created, the time-and-date (T.A.D.) stamps for these files
will be updated.

When the client calls in for an update, EZDialup can take the T.A.D.
stamp of a selected file (let's call it the "time" file, essentially
the "new-ness" of the client-side data), gather all server files that
are newer, then transfer them to the appropriate directories on the
client PC.

One of these newer files will be the server version of the "time" file,
\so the client-side "time" file will have a new time-and-date stamp.
If the user were to immediately update again, the server side would
find no files newer and issue an "Up to date" message to the client.

To make this work, the time-and-date stamp of the control file on the
server must be given a new T.A.D. stamp every time the a file in the
directory structure is changed or created.  The only downside to
overlooking this rule is that the client-side software would not
realize how "new" and up-to-date it is the next time it calls and
might end up retrieving some files unnecessarily.

Note that we've specified that changing or creating files will result
is new time-and-date stamps.  If you copy an existing file into the
structure, the T.A.D. will be the same as the original, which might not
be newer than the "time" file.
*)

function  EZMailUpdate(ServerMailboxPath,
                       ClientMailDirectory:pchar):word;
(*
Used to perform a mail update.  Works only with EZ Software's EZMail.
The first parameter (ServerMailboxPath) is the location and name of
the user's mailbox on the server side.  The second parameter
(ClientMailDirectory) is the location of EZMail on the user's remote PC.
*)

procedure EstablishLinkAsTerminal;
(*
Used by an application to dial a BBS.
*)


Function SerialIOWaiting:boolean;
Function GetSerialByte:integer;
function SendSerialByte(SendByte:byte):boolean;
function SendSerialString(Sendstr:pchar):boolean;
function SetupNotification(SearchStr,ResponseStr:pchar;Index,Message:word):word;
procedure DisableAllNotifications;          
procedure ReEnableAllNotifications; 
procedure StartTerminalDownload(LocalFilePath:pchar;ProtocolCode:integer);
procedure StartTerminalUpload(LocalFilePath:pchar;ProtocolCode:integer);
procedure InterruptFileTransfer;
procedure EstablishCommPortLink;        
procedure SupplyRegistrationCodes(Code1,Code2:pchar);

implementation

procedure StartSession;                 EXTERNAL 'APPDIAL'  index 1;
procedure AbortSession;                 EXTERNAL 'APPDIAL'  index 2;
Procedure ChangePhoneNumber;            EXTERNAL 'APPDIAL'  index 3;
Procedure StopEZDialup;                 EXTERNAL 'APPDIAL'  index 4;

Procedure SetParentWindow;            EXTERNAL 'APPDIAL'  index 5;
Procedure SetDialingSequence;         EXTERNAL 'APPDIAL'  index 6;
Procedure SetDialupCommPort;          EXTERNAL 'APPDIAL'  index 7;
Procedure SetDialupCommConfig;        EXTERNAL 'APPDIAL'  index 8;
Procedure SetModemInit1;              EXTERNAL 'APPDIAL'  index 9;
Procedure SetModemInit2;              EXTERNAL 'APPDIAL'  index 10;
Procedure SetDownloadBlockSize;       EXTERNAL 'APPDIAL'  index 11;
Procedure SetUploadBlockSize;         EXTERNAL 'APPDIAL'  index 12;
procedure SetLinkUserPath;            EXTERNAL 'APPDIAL'  index 13;
procedure SetLinkUserPassword;        EXTERNAL 'APPDIAL'  index 14;
procedure SetExecutablePath;          EXTERNAL 'APPDIAL'  index 15;
procedure EstablishDialupLink;        EXTERNAL 'APPDIAL'  index 16;

function StartDownload;               EXTERNAL 'APPDIAL'  index 17;
function StartUpload;                 EXTERNAL 'APPDIAL'  index 18;
function StartMoveDown;               EXTERNAL 'APPDIAL'  index 19;
function StartMoveUp;                 EXTERNAL 'APPDIAL'  index 20;
function UnzipServerFile;             EXTERNAL 'APPDIAL'  index 21;
function UnzipClientFile;             EXTERNAL 'APPDIAL'  index 22;
function ZipServerFile;               EXTERNAL 'APPDIAL'  index 23;
function ZipClientFile;               EXTERNAL 'APPDIAL'  index 24;
function DeleteFilesOnServer;         EXTERNAL 'APPDIAL'  index 25;
function DeleteFilesOnClient;         EXTERNAL 'APPDIAL'  index 26;
function RunProgramOnServer;          EXTERNAL 'APPDIAL'  index 27;
function RunProgramOnClient;          EXTERNAL 'APPDIAL'  index 28;
function LaunchProgramOnServer;       EXTERNAL 'APPDIAL'  index 29;
function LaunchProgramOnClient;       EXTERNAL 'APPDIAL'  index 30;
function UpdateClientDirectory;       EXTERNAL 'APPDIAL'  index 31;
function EZMailUpdate;                EXTERNAL 'APPDIAL'  index 32;
                                       
procedure EstablishLinkAsTerminal;    EXTERNAL 'APPDIAL'  index 33;      
Function SerialIOWaiting;             EXTERNAL 'APPDIAL'  index 34;
Function GetSerialByte;               EXTERNAL 'APPDIAL'  index 35;
function SendSerialByte;              EXTERNAL 'APPDIAL'  index 36;         
function SendSerialString;            EXTERNAL 'APPDIAL'  index 37;
function SetupNotification;           EXTERNAL 'APPDIAL'  index 38;
procedure DisableAllNotifications;    EXTERNAL 'APPDIAL'  index 39;
procedure ReEnableAllNotifications;   EXTERNAL 'APPDIAL'  index 40;
procedure StartTerminalDownload;        EXTERNAL 'APPDIAL'  index 41;
procedure StartTerminalUpload;          EXTERNAL 'APPDIAL'  index 42;
procedure InterruptFileTransfer;        EXTERNAL 'APPDIAL'  index 43;
procedure EstablishCommPortLink;        EXTERNAL 'APPDIAL'  index 44;
procedure SupplyRegistrationCodes;      EXTERNAL 'APPDIAL'  index 45;




end.


